<#ibiztemplate>
TARGET=PSAPPDEUILOGIC
</#ibiztemplate>
<#ibizinclude>
../@MACRO/ui-logic-node.txt
</#ibizinclude>
import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
/**
 * ${item.name}
 *
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}UILogicBase
 */
export default class ${srfclassname('${item.getCodeName()}')}UILogicBase {

    /**
     * Creates an instance of  ${item.codeName}Base.
     * 
     * @param {*} [opts={}]
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 开始节点
     *
     * @protected
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    protected readonly startLogicNode: string = '<#if item.getStartPSDEUILogicNode?? && item.getStartPSDEUILogicNode()??>${item.getStartPSDEUILogicNode().codeName}</#if>';

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    protected logicParams: any[] = [
<#if item.getPSDEUILogicParams?? && item.getPSDEUILogicParams()??>
    <#list item.getPSDEUILogicParams() as logicParam>
        {
            name: '${logicParam.name}',
            codeName: '${logicParam.codeName}',
        <#if logicParam.isActiveContainerParam?? && logicParam.isActiveContainerParam()>
            activeContainerParam: true,
        </#if>
        <#if logicParam.isActiveCtrlParam?? && logicParam.isActiveCtrlParam()>
            activeCtrlParam: true,
        </#if>
        <#if logicParam.isActiveViewParam?? && logicParam.isActiveViewParam()>
            activeViewParam: true,
        </#if>
        <#if logicParam.isAppGlobalParam?? && logicParam.isAppGlobalParam()>
            appGlobalParam: true,
        </#if>
        <#if logicParam.isApplicationParam?? && logicParam.isApplicationParam()>
            applicationParam: true,
        </#if>
        <#if logicParam.isCtrlParam?? && logicParam.isCtrlParam()>
            ctrlParam: true,
        </#if>
        <#if logicParam.isDefault?? && logicParam.isDefault()>
            default: true,
        </#if>
        <#if logicParam.isEntityParam?? && logicParam.isEntityParam()>
            entityParam: true,
        </#if>
        <#if logicParam.isEntityListParam?? && logicParam.isEntityListParam()>
            entityListParam: true,
        </#if>
        <#if logicParam.isEntityPageParam?? && logicParam.isEntityPageParam()>
            entityPageParam: true,
        </#if>
        <#if logicParam.isFilterParam?? && logicParam.isFilterParam()>
            filterParam: true,
        </#if>
        <#if logicParam.isNavContextParam?? && logicParam.isNavContextParam()>
            navContextParam: true,
        </#if>
        <#if logicParam.isSimpleParam?? && logicParam.isSimpleParam()>
            simpleParam: true,
        </#if>
        <#if logicParam.isSimpleListParam?? && logicParam.isSimpleListParam()>
            simpleListParam: true,
        </#if>
        <#if logicParam.isRouteViewSessionParam?? && logicParam.isRouteViewSessionParam()>
            routeViewSessionParam: true,
        </#if>
        <#if logicParam.isViewNavDataParam?? && logicParam.isViewNavDataParam()>
            viewNavDataParam: true,
        </#if>
        <#if logicParam.isViewSessionParam?? && logicParam.isViewSessionParam()>
            viewSessionParam: true,
        </#if>
        <#if logicParam.isLastReturnParam?? && logicParam.isLastReturnParam()>
            lastReturnParam: true
        </#if>
        },
    </#list>
</#if>
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            <#if item.getStartPSDEUILogicNode?? && item.getStartPSDEUILogicNode()??>
            await this.execute_${item.getStartPSDEUILogicNode().codeName?lower_case}_node(actionContext);
            <#else>
            throw new Error('没有开始节点');
            </#if>
            return actionContext.getResult();
        } catch (error: any) {
            <#noparse>throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);</#noparse>
        }
    }

<#if item.getPSDEUILogicNodes?? && item.getPSDEUILogicNodes()??>
    <#list item.getPSDEUILogicNodes() as logicNode>
    <@executenode logicNode/>
    
    </#list>
</#if>

}